	function Amax = BW_Amax_Z(N, wcT, Amax, Amin)
	
	% 	Computes Amax  for a lowpass digital Butterworth filter of order N
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW 2018-04-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi	
	
	if N ~= round(N)
		disp([ 'Must be an integer'])
		break
	end
	Ome = tan(wsT/2)/tan(wcT/2);
	Amax = 10*log10(1+(10^(Amin/10)-1)/Ome^(2*N));
	
	
